/**
 * Created by kal on 05/06/2017.
 */
$(function(){
    //get the form
    var form = $("#ajax-contact");

    //get messages div
    var formMessages = $("#form-messages");

    $(form).submit(function(event){
        event.preventDefault();
        var formData = $(form).serialize();

        if(grecaptcha.getResponse().length === 0){
            $(formMessages).text("Please complete the captcha.");
            $(formMessages).css('color','red');
        }else if(!validateEmail($('#email').val())){
            $(formMessages).text("Please enter a valid email address.");
            $(formMessages).css('color','red');
            grecaptcha.reset();
        }else{
            $.ajax({
                type: 'POST',
                url: $(form).attr('action'),
                data: formData
            }).done(function(response){
                $(formMessages).text(response);
                $(formMessages).css('color','#555');
                $(form).trigger('reset');
            }).fail(function(response){
                $(formMessages).css('color','red');
                $(formMessages).text(response);
            });
            grecaptcha.reset();
        }
    });
});
function validateEmail(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}
function recaptchaCallback() {
    $('#submit').removeAttr('disabled');
};